#pragma once

#include <maps/wikimap/mapspro/services/tasks-ng/lib/task_module.h>

#include <map>
#include <memory>
#include <mutex>
#include <vector>

namespace maps {
namespace wiki {
namespace tasks_ng {

class TaskModuleRegistry
{
public:
    static TaskModuleRegistry& get();

    template <typename Module>
    std::shared_ptr<Module> registerModule()
    {
        auto module = std::make_shared<Module>();
        add(module);
        return module;
    }

    std::shared_ptr<TaskModule> modulePtr(const std::string& taskType) const;
    const TaskModule& module(const std::string& taskType) const;

    std::vector<std::shared_ptr<TaskModule>> allModules() const;

private:
    TaskModuleRegistry() = default;

    void add(std::shared_ptr<TaskModule> taskModule);

    mutable std::mutex mutex_;
    std::map<std::string, std::shared_ptr<TaskModule>> modules_;
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
