#pragma once

#include <maps/wikimap/mapspro/services/tasks-ng/lib/common.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/db_context.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/request_parameters.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/xml_response_wrapper.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

std::string getTaskLog(
    DbContext& ctx,
    Id taskId);

void makeResponseSetTaskStatus(
    DbContext& ctx,
    XmlResponseWrapper& wrapper,
    Id taskId,
    Uid uid,
    ServiceTaskStatus status);

void makeResponseTask(
    DbContext& ctx,
    XmlResponseWrapper& wrapper,
    Id taskId);

void makeResponseTasks(
    DbContext& ctx,
    XmlResponseWrapper& wrapper,
    const std::string& taskType,
    Uid createdBy,
    Id parentId,
    size_t page,
    size_t perPage);

void makeResponseCapabilities(
    XmlResponseWrapper& wrapper,
    const std::string& taskType);

void makeResponseCreateTask(
    DbContext& ctx,
    XmlResponseWrapper& wrapper,
    const std::string& taskType,
    Uid uid,
    Id parentId,
    const RequestParameters& parameters);

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
