#pragma once

#include <maps/wikimap/mapspro/services/tasks-ng/lib/xml_writer.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

class XmlResponseWrapper
{
public:
    template <typename Response>
    explicit XmlResponseWrapper(Response& response)
        : writer_(response)
    {
        response["Content-Type"] = "text/xml";
    }

    XmlWriter& writer()
    {
        return writer_;
    }

    template <typename F>
    void write(const std::string& rootElement, const F& f)
    {
        writer_.addXmlVersion();
        writer_.addTag(rootElement, [&] {
            writer_.addAttribute("xmlns", "http://maps.yandex.ru/mapspro/tasks/1.x");
            f();
        });
    }

    template <typename F>
    void write(const F& f)
    {
        write("tasks", f);
    }

private:
    XmlWriter writer_;
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
