#include <maps/wikimap/mapspro/services/tasks-ng/modules/acl.h>

#include <maps/wikimap/mapspro/services/tasks-ng/lib/exception.h>

namespace maps {
namespace wiki {
namespace tasks_ng {
namespace modules {

void checkPermission(
    DbContext& ctx,
    const Task& task,
    const acl::SubjectPath& aclPath,
    const std::string& wkb)
{
    auto& txnCore = ctx.txnCore();
    auto uid = task.createdBy();

    std::vector<std::string> wkbs;
    if (!wkb.empty()) {
        wkbs.push_back(wkb);
    }

    acl::CheckContext context(uid, wkbs, txnCore, {acl::User::Status::Active});
    TASKS_REQUIRE(
        aclPath.isAllowed(context),
        ERR_FORBIDDEN,
        "Unallowed operation, task " << task.type() << ", user: " << uid);
}

} // namespace modules
} // namespace tasks_ng
} // namespace wiki
} // namespace maps
