#include <maps/wikimap/mapspro/services/tasks-ng/modules/helpers.h>

#include <maps/wikimap/mapspro/services/tasks-ng/modules/exception.h>

#include <yandex/maps/wiki/common/geojson.h>

namespace maps::wiki::tasks_ng::modules {

std::string mercatorWkbToGeoJson(const std::string& wkb)
{
    return common::mercatorWkbToGeoJson(wkb);
}

std::string geoJsonToMercatorWkb(const std::string& geoJson)
{
    try {
        return common::geoJsonToMercatorWkb(geoJson);
    } catch (const std::exception& ex) {
        THROW_TASKS_ERROR(ERR_TOPO_INVALID_GEOMETRY, "Invalid geometry: " << ex.what());
    }
}

} // namespace maps::wiki::tasks_ng::modules
