#include <maps/wikimap/mapspro/services/tasks-ng/modules/acl.h>
#include <maps/wikimap/mapspro/services/tasks-ng/modules/common.h>

namespace maps {
namespace wiki {
namespace tasks_ng {
namespace modules {
namespace prepare_stable_branch {

const std::string TASK_TYPE = "prepare_stable_branch";

const acl::SubjectPath ACL_PATH("mpro/tasks/prepare-stable-branch");

class Module : public TaskModule
{
public:
    std::string name() const override { return TASK_TYPE; }

    void onCreate(DbContext& ctx, Task& task, const RequestParameters&) const override
    {
        checkPermission(ctx, task, ACL_PATH);
    }

    json::Value launchParameters(const Task& task) const override
    {
        return json::Value{
            { TYPE, json::Value{TASK_TYPE} },
            { TASK_ID, json::Value{task.id()} },
            { UID, json::Value{task.createdBy()} }
        };
    }
};

const auto module = TaskModuleRegistry::get().registerModule<Module>();

} // namespace prepare_stable_branch
} // namespace modules
} // namespace tasks_ng
} // namespace wiki
} // namespace maps
