#include <maps/wikimap/mapspro/services/tasks-ng/modules/revision_helpers.h>

#include <yandex/maps/wiki/revision/branch_manager.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

namespace maps {
namespace wiki {
namespace tasks_ng {
namespace modules {

namespace {

const std::string BRANCH_TRUNK = "0";

const std::string PARAM_BRANCH = "branch";
const std::string PARAM_COMMIT = "commit";

} // namespace


revision::Branch getBranch(
    DbContext& ctx,
    const RequestParameters& parameters)
{
    auto branch = parameters.getValue<std::string>(PARAM_BRANCH, BRANCH_TRUNK);
    return revision::BranchManager(ctx.txnCore()).loadByString(branch);
}

revision::DBID getCommitId(
    DbContext& ctx,
    const RequestParameters& parameters,
    const revision::Branch& branch)
{
    auto commitId = parameters.getValue<revision::DBID>(PARAM_COMMIT, 0);
    if (commitId) {
        return commitId;
    }
    return revision::RevisionsGateway(ctx.txnCore(), branch).headCommitId();
}

} // namespace modules
} // namespace tasks_ng
} // namespace wiki
} // namespace maps
