import logging
from yandex.maps.wiki import db, pgpool3
from yandex.maps.wiki import config
from yandex.maps.wiki.log import setup_logging

from maps.wikimap.mapspro.services.tasks.fastcgi.lib.impl import tasks as app

setup_logging()
logging.info('Starting {}'.format(app))

config.init_config()
if hasattr(config.get_config(), 'databases'):
    db.init_pool(['core', 'validation'])
    pgpool3.init_pgpool(config.get_config().databases[db.CORE_DB], db.POOL_ROLE)
else:
    logging.error('Failed to init config. It is normal during the import test')
