import argparse
from yandex.maps.wiki import config, db


def parse_args():
    arg_parser = argparse.ArgumentParser(
        description='Check dns alias of master core database')
    arg_parser.add_argument(
        '--config', type=str,
        help='full path to services.xml')
    return arg_parser.parse_args()


def main():
    args = parse_args()
    try:
        config.init_config(args.config)
        db.init_pool(['core'], 'core')

        with db.get_write_session('core') as session:
            if session.execute('SELECT pg_is_in_recovery()').scalar():
                print('2;Master core db is REPLICA')
            else:
                print('0;Ok')
    except Exception as ex:
        print('1;Monitoring broken:', ex)
