import pytest
from lxml import etree as ET

TEST_UID = 1


def test_ping(client):
    response = client.get('/ping')
    assert response.status_code == 200
    assert response.data == 'ok'


@pytest.mark.usefixtures('setup_acl_groups')
@pytest.mark.usefixtures('clean_schema')
def test_tasks(client, xmlschema):
    response = client.get('/tasks', data={
        'uid': TEST_UID
    })
    assert response.status_code == 200

    root = ET.fromstring(response.data)
    xmlschema.assertValid(root)


@pytest.mark.usefixtures('setup_acl_groups')
@pytest.mark.usefixtures('setup_permissions')
def test_capabilities(client, xmlschema):
    response = client.get('/capabilities', data={
        'uid': TEST_UID
    })
    assert response.status_code == 200

    root = ET.fromstring(response.data)
    xmlschema.assertValid(root)
