import mock
import pytest
from lxml import etree as ET

TEST_UID = 1
TEST_SCHEDULE_ID = 1
TEST_SCHEDULE_NAME = 'Test schedule'

TEST_BRANCH_TYPE = 'stable'
TEST_PRESET_ID = '1'
TEST_REGION_ID = '2345'

TEST_DAY = 45
TEST_TIME = '12:30'

TEST_CRON_EXPR = '30 12 * * 1,3,4,6'
TEST_CRON_TASK_NAME = 'tasks_validation_1_1'

TEST_GRINDER_ARGS = {
    'type': 'submit-editor-task',
    'task-type': 'validation',
    'uid': TEST_UID,
    'params': {
        'branch': TEST_BRANCH_TYPE,
        'preset': TEST_PRESET_ID,
        'region': TEST_REGION_ID
    }
}


def assertResponseValid(response, xmlschema):
    assert response.status_code == 200
    root = ET.fromstring(response.data)
    xmlschema.assertValid(root)


@pytest.fixture(scope='function')
def grinder_class():
    with mock.patch('maps.wikimap.mapspro.services.tasks.fastcgi.lib.schedule.grinder.GrinderGateway') as grinder_class:
        yield grinder_class


@pytest.mark.usefixtures('setup_acl_groups')
@pytest.mark.usefixtures('clean_schema')
def test_schedule(client, xmlschema, grinder_class):
    grinder_instance = grinder_class.return_value

    # test create schedule

    response = client.post('/schedule/items', query_string={
        'uid': TEST_UID,
        'name': TEST_SCHEDULE_NAME,
        'type': 'validation',
        'enabled': 'true',
        'day': TEST_DAY,
        'time': TEST_TIME
    }, data='<?xml version="1.0" encoding="utf-8"?>'
        '<tasks xmlns="http://maps.yandex.ru/mapspro/tasks/1.x">'
        '<request-save-schedule-item>'
        '<validation-params>'
        '<branch-type>' + TEST_BRANCH_TYPE + '</branch-type>'
        '<preset>' + TEST_PRESET_ID + '</preset>'
        '<region>' + TEST_REGION_ID + '</region>'
        '</validation-params>'
        '</request-save-schedule-item>'
        '</tasks>'
    )
    assertResponseValid(response, xmlschema)

    # test grinder

    grinder_instance.put_crontab.assert_called_once_with(
        args=TEST_GRINDER_ARGS,
        cron_expr=TEST_CRON_EXPR,
        cron_task_name=TEST_CRON_TASK_NAME)

    # test brief schedule items

    response = client.get('/schedule/items', data={'uid': TEST_UID})
    assertResponseValid(response, xmlschema)

    # test full schedule item

    response = client.get('/schedule/items/' + str(TEST_SCHEDULE_ID), data={'uid': TEST_UID})
    assertResponseValid(response, xmlschema)

    # test delete schedule

    response = client.delete(
        '/schedule/items/' + str(TEST_SCHEDULE_ID),
        query_string={
            'uid': TEST_UID
        })
    assertResponseValid(response, xmlschema)
