#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::AD_NEUTRAL;
using maps::wiki::validator::categories::AD_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( ad_neutral_naming, AD_NEUTRAL, AD_NM )
{
    context->objects<AD_NEUTRAL>().visit([&](const ContourFeature* adNeutral) {
        utils::runBasicNamesCheck<AD_NM>(adNeutral, context);
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
