#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::AD_NEUTRAL;
using maps::wiki::validator::categories::AD_NEUTRAL_FC;
using maps::wiki::validator::categories::AD_NEUTRAL_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        ad_neutral_relations, face_elements_relations, AD_NEUTRAL_EL, AD_NEUTRAL_FC )
{
    utils::runElementsRelationsCheck<AD_NEUTRAL_EL, AD_NEUTRAL_FC>(
            context, Severity::Critical);
}

VALIDATOR_CHECK_PART(
        ad_neutral_relations, faces_relations, AD_NEUTRAL_FC, AD_NEUTRAL_EL, AD_NEUTRAL )
{
    utils::runFacesRelationsCheck<AD_NEUTRAL_FC, AD_NEUTRAL>(context);
}

VALIDATOR_CHECK_PART(
        ad_neutral_relations, compound_objects_relations, AD_NEUTRAL, AD_NEUTRAL_FC )
{
    utils::runFeatureRelationsCheck<AD_NEUTRAL>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
