#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::AD_NEUTRAL_FC;
using maps::wiki::validator::categories::AD_NEUTRAL_EL;
using maps::wiki::validator::categories::AD_NEUTRAL_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( ad_neutral_topology, segments_length, AD_NEUTRAL_EL )
{
    utils::runSegmentsLengthCheck<AD_NEUTRAL_EL>(context);
}

VALIDATOR_CHECK_PART( ad_neutral_topology, intersections, AD_NEUTRAL_FC, AD_NEUTRAL_EL )
{
    utils::runFaceElementsIntersectionsCheck<AD_NEUTRAL_EL, AD_NEUTRAL_FC>(context);
}

VALIDATOR_CHECK_PART( ad_neutral_topology, jc_el_coverage, AD_NEUTRAL_EL, AD_NEUTRAL_JC )
{
    utils::runJcElCoverageCheck<AD_NEUTRAL_EL, AD_NEUTRAL_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( ad_neutral_topology, open_bounds, AD_NEUTRAL_JC )
{
    utils::runOpenBoundsCheck<AD_NEUTRAL_JC>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
