#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

namespace maps::wiki::validator::checks {

using categories::ADDR;
using categories::ARRIVAL_POINT;

VALIDATOR_SIMPLE_CHECK( arrival_point_uniqueness, ADDR, ARRIVAL_POINT )
{
    context->objects<ADDR>().visit([&](const AddressPoint* addressPoint)
    {
        std::vector<TId> majorArrivalPointsIds;
        for (auto arrivalPointId : addressPoint->arrivalPoints()) {
            if (context->objects<ARRIVAL_POINT>().loaded(arrivalPointId)) {
                auto arrivalPoint = context->objects<ARRIVAL_POINT>().byId(arrivalPointId);
                if (arrivalPoint->isMajor()) {
                    majorArrivalPointsIds.push_back(arrivalPoint->id());
                }
            }
        }
        if (majorArrivalPointsIds.size() > 1) {
            context->fatal("duplicate-major-arrival-point",
                addressPoint->geom(),
                majorArrivalPointsIds);
        }
    });
}

} // maps::wiki::validator::checks
