#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <maps/wikimap/mapspro/libs/flat_range/include/range.h>
#include <maps/wikimap/mapspro/libs/flat_range/include/validation.h>

namespace maps::wiki::validator::checks {

using categories::FLAT_RANGE;
using categories::POI_ENTRANCE;
namespace {
struct MessageDef
{
    Severity severity;
    std::string text;
};

const std::map<flat_range::ValidationResult, MessageDef> VALIDATION_RESULT_TO_MESSAGE_DEF =
{
    {flat_range::ValidationResult::BadFlatRange, {Severity::Critical, "bad-flat-range"}},
    {flat_range::ValidationResult::BadLevelRange, {Severity::Critical, "bad-level-range"}},
    {flat_range::ValidationResult::FlatRangesIntersection, {Severity::Critical, "flat-ranges-intersection"}},
    {flat_range::ValidationResult::FlatsOutOfRange, {Severity::Fatal, "flats-out-of-range"}},
    {flat_range::ValidationResult::LevelsOutOfRange, {Severity::Critical, "levels-out-of-range"}},
    {flat_range::ValidationResult::TooManyFlatsPerEntrance, {Severity::Critical, "too-many-flats-per-entrance"}},
};
} // namespace

VALIDATOR_SIMPLE_CHECK( flat_range, FLAT_RANGE, POI_ENTRANCE )
{
    context->objects<POI_ENTRANCE>().visit([&](const PoiEntrance* entrance)
    {
        std::vector<flat_range::FlatLevelRange> flatLevelRanges;

        for (const auto flatRangeId : entrance->flatRanges()) {
            auto flatRange = context->objects<FLAT_RANGE>().byId(flatRangeId);
            flatLevelRanges.push_back({
                flatRange->flats(),
                flatRange->levels() ? *flatRange->levels() : ""});
        }

        auto results = flat_range::validate(flatLevelRanges);
        for (const auto& result : results) {
            const auto mesageDefIt = VALIDATION_RESULT_TO_MESSAGE_DEF.find(result);
            if (mesageDefIt == VALIDATION_RESULT_TO_MESSAGE_DEF.end()) {
                continue;
            }
            const auto& messageDef = mesageDefIt->second;
            context->report(
                messageDef.severity,
                messageDef.text,
                entrance->geom(),
                {entrance->id()});
        }
    });
}

} // maps::wiki::validator::checks
