#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/face_builder.h"
#include "../utils/face_checks.h"
#include "../utils/misc.h"

#include <maps/libs/geolib/include/polygon.h>

using maps::wiki::validator::categories::AD_FC;
using maps::wiki::validator::categories::AD_SUBST_FC;
using maps::wiki::validator::categories::AD_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

const double MIN_FACE_AREA = 100.0; // square meters
const double MAX_FACE_PERIMETER_TO_AREA_RATIO = 0.06; // meters / meters^2

} // namespace

VALIDATOR_SIMPLE_CHECK( ad_fc_validity, AD_FC, AD_SUBST_FC, AD_EL )
{
    utils::runFaceValidityCheck<AD_FC>(context);
    utils::runFaceValidityCheck<AD_SUBST_FC>(context);

    utils::runFaceDimensionsCheck<AD_FC>(
            context,
            Severity::Error,
            MIN_FACE_AREA,
            MAX_FACE_PERIMETER_TO_AREA_RATIO);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
