#include "module.h"
#include "../utils/relations_checks.h"
#include "../utils/category_traits.h"

#include <yandex/maps/wiki/validator/check.h>

#include <yandex/maps/wiki/validator/categories.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::AD_CNT;
using categories::AD_FC;
using categories::AD_SUBST_FC;
using categories::AD_EL;
using categories::AD;
using categories::AD_SUBST;


VALIDATOR_CHECK_PART(
        ad_relations, elements_relations, AD_EL, AD_FC, AD_SUBST_FC )
{
    context->objects<AD_EL>().visit(
            [&](const Edge* element)
    {
        if (element->parents().empty()) {
            context->fatal(
                    "stray-element", utils::geomForReport(element), {element->id()});
        }
    });
}

VALIDATOR_CHECK_PART(
        ad_relations, faces_relations, AD_EL, AD_SUBST_FC, AD_FC, AD, AD_SUBST )
{
    utils::runFacesRelationsCheck<AD_FC, AD>(context);
    utils::runFacesRelationsCheck<AD_SUBST_FC, AD_SUBST>(context);
}

VALIDATOR_CHECK_PART(
        ad_relations, compound_objects_relations, AD_CNT, AD_FC, AD )
{
    context->objects<AD>().visit([&](const AdmUnit* admUnit) {
        if (!admUnit->center() && admUnit->faces().empty()) {
            context->fatal(
                    "empty-adm-unit", boost::none, {admUnit->id()});
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
