#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::AD_FC;
using maps::wiki::validator::categories::AD_SUBST_FC;
using maps::wiki::validator::categories::AD_EL;
using maps::wiki::validator::categories::AD_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( ad_topology, segments_length, AD_EL )
{
    utils::runSegmentsLengthCheck<AD_EL>(context);
}

VALIDATOR_CHECK_PART( ad_topology, intersections, AD_FC, AD_EL )
{
    utils::runFaceElementsIntersectionsCheck<AD_EL, AD_FC>(context);
}

VALIDATOR_CHECK_PART( ad_topology, jc_el_coverage, AD_EL, AD_JC )
{
    utils::runJcElCoverageCheck<AD_EL, AD_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::Yes);
}

VALIDATOR_CHECK_PART( ad_topology, open_bounds, AD_JC )
{
    utils::runOpenBoundsCheck<AD_JC>(context);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
