#ifndef YANDEX_MAPS_BUILD
#define MODULE_NAME "base-only-check"
#endif

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( base_only, hydro
, categories::HYDRO
, categories::HYDRO_FC
, categories::HYDRO_FC_EL
, categories::HYDRO_FC_JC
, categories::HYDRO_LN
, categories::HYDRO_LN_EL
, categories::HYDRO_LN_JC
, categories::HYDRO_POINT
, categories::HYDRO_NM
    )
{ (void)context; }

VALIDATOR_CHECK_PART( base_only, other
, categories::RD_EL
, categories::RD
, categories::RD_JC
, categories::RD_NM
, categories::COND
, categories::COND_ANNOTATION
, categories::COND_CAM
, categories::COND_TRAFFIC_LIGHT
, categories::COND_LANE
, categories::COND_TOLL
, categories::COND_DS
, categories::COND_DS_EL
, categories::COND_DT
, categories::FREQ_DT
, categories::AD_EL
, categories::AD_JC
, categories::AD_FC
, categories::AD_CNT
, categories::AD
, categories::AD_NM
, categories::AD_SUBST_FC
, categories::AD_SUBST
, categories::ADDR
, categories::ADDR_NM
, categories::ZIPCODE
, categories::ZIPCODE_NM
, categories::ARRIVAL_POINT
, categories::ARRIVAL_POINT_NM
, categories::FLAT_RANGE
, categories::BLD
, categories::BLD_COMPLEX
, categories::TRANSPORT_METRO_LINE
, categories::TRANSPORT_METRO_STATION
, categories::TRANSPORT_METRO_EXIT
, categories::TRANSPORT_METRO_EL
, categories::TRANSPORT_METRO_JC
, categories::TRANSPORT_METRO_NM
, categories::TRANSPORT_OPERATOR
, categories::TRANSPORT_METRO_THREAD
, categories::TRANSPORT_TRAM_THREAD
, categories::TRANSPORT_WATERWAY_THREAD
, categories::TRANSPORT_BUS_THREAD
, categories::TRANSPORT_BUS_ROUTE
, categories::TRANSPORT_THREAD_STOP
, categories::TRANSPORT_TRANSITION
, categories::TRANSPORT_PASSAGEWAY
, categories::TRANSPORT_TRANSITION_BOARDING
, categories::TRANSPORT_PASSAGEWAY_BOARDING
, categories::TRANSPORT_RAILWAY
, categories::TRANSPORT_RAILWAY_STATION
, categories::TRANSPORT_RAILWAY_PLATFORM
, categories::TRANSPORT_RAILWAY_EL
, categories::TRANSPORT_RAILWAY_JC
, categories::TRANSPORT_RAILWAY_NM
, categories::TRANSPORT_TRAM_ROUTE
, categories::TRANSPORT_STOP
, categories::TRANSPORT_TERMINAL
, categories::TRANSPORT_TRAM_EL
, categories::TRANSPORT_TRAM_JC
, categories::TRANSPORT_NM
, categories::TRANSPORT_AIRPORT
, categories::TRANSPORT_AIRPORT_TERMINAL
, categories::TRANSPORT_HELICOPTER
, categories::TRANSPORT_AIRPORT_NM
, categories::TRANSPORT_WATERWAY_ROUTE
, categories::TRANSPORT_WATERWAY_STOP
, categories::TRANSPORT_WATERWAY_EL
, categories::TRANSPORT_WATERWAY_JC
, categories::TRANSPORT_WATERWAY_NM
, categories::VEGETATION
, categories::VEGETATION_CNT
, categories::VEGETATION_FC
, categories::VEGETATION_EL
, categories::VEGETATION_JC
, categories::VEGETATION_NM
, categories::URBAN
, categories::URBAN_FC
, categories::URBAN_EL
, categories::URBAN_JC
, categories::URBAN_NM
, categories::URBAN_AREAL
, categories::URBAN_ROADNET
, categories::URBAN_ROADNET_FC
, categories::URBAN_ROADNET_EL
, categories::URBAN_ROADNET_JC
, categories::URBAN_ROADNET_AREAL
, categories::URBAN_ROADNET_PARKING_LOT
, categories::URBAN_ROADNET_PARKING_LOT_LINEAR
, categories::URBAN_ROADNET_PARKING_CONTROLLED_ZONE
, categories::URBAN_ROADNET_NM
, categories::RELIEF
, categories::RELIEF_POINT
, categories::RELIEF_FC
, categories::RELIEF_EL
, categories::RELIEF_JC
, categories::RELIEF_NM
, categories::POI_MEDICINE
, categories::POI_EDU
, categories::POI_FINANCE
, categories::POI_SHOPPING
, categories::POI_GOVERMENT
, categories::POI_RELIGION
, categories::POI_FOOD
, categories::POI_AUTO
, categories::POI_SPORT
, categories::POI_LEISURE
, categories::POI_URBAN
, categories::POI_SERVICE
, categories::POI_OTHER
, categories::POI_NM
, categories::INDOOR_PLAN
, categories::INDOOR_LEVEL
, categories::INDOOR_AREA
, categories::INDOOR_NM
, categories::INDOOR_POI_AUTO
, categories::INDOOR_POI_FOOD
, categories::INDOOR_POI_SHOPPING
, categories::INDOOR_POI_RELIGION
, categories::INDOOR_POI_SERVICE
, categories::INDOOR_POI_FINANCE
, categories::INDOOR_POI_MEDICINE
, categories::INDOOR_POI_EDU
, categories::INDOOR_POI_LEISURE
, categories::INDOOR_POI_SPORT
, categories::INDOOR_POI_GOVERMENT
, categories::INDOOR_POI_NM
, categories::POI_ENTRANCE
, categories::AD_NEUTRAL
, categories::AD_NEUTRAL_FC
, categories::AD_NEUTRAL_EL
, categories::AD_NEUTRAL_JC
, categories::REGION
, categories::VEHICLE_RESTRICTION
, categories::MRC_PEDESTRIAN_REGION
, categories::INDOOR_RADIOMAP_CAPTURER_PATH
    )
{ (void)context; }


VALIDATOR_CHECK_PART( base_with_cardinality, hydro
, categories::HYDRO
, categories::HYDRO_FC
, categories::HYDRO_FC_EL
, categories::HYDRO_FC_JC
, categories::HYDRO_LN
, categories::HYDRO_LN_EL
, categories::HYDRO_LN_JC
, categories::HYDRO_POINT
, categories::HYDRO_NM
    )
{ (void)context; }

VALIDATOR_CHECK_PART( base_with_cardinality, other
, categories::RD_EL
, categories::RD
, categories::RD_JC
, categories::RD_NM
, categories::COND
, categories::COND_ANNOTATION
, categories::COND_CAM
, categories::COND_TRAFFIC_LIGHT
, categories::COND_LANE
, categories::COND_TOLL
, categories::COND_DS
, categories::COND_DS_EL
, categories::COND_DT
, categories::FREQ_DT
, categories::AD_EL
, categories::AD_JC
, categories::AD_FC
, categories::AD_CNT
, categories::AD
, categories::AD_NM
, categories::AD_SUBST_FC
, categories::AD_SUBST
, categories::ADDR
, categories::ADDR_NM
, categories::ZIPCODE
, categories::ZIPCODE_NM
, categories::ARRIVAL_POINT
, categories::ARRIVAL_POINT_NM
, categories::FLAT_RANGE
, categories::BLD
, categories::BLD_COMPLEX
, categories::TRANSPORT_METRO_LINE
, categories::TRANSPORT_METRO_STATION
, categories::TRANSPORT_METRO_EXIT
, categories::TRANSPORT_METRO_EL
, categories::TRANSPORT_METRO_JC
, categories::TRANSPORT_METRO_NM
, categories::TRANSPORT_OPERATOR
, categories::TRANSPORT_METRO_THREAD
, categories::TRANSPORT_TRAM_THREAD
, categories::TRANSPORT_WATERWAY_THREAD
, categories::TRANSPORT_BUS_THREAD
, categories::TRANSPORT_BUS_ROUTE
, categories::TRANSPORT_THREAD_STOP
, categories::TRANSPORT_TRANSITION
, categories::TRANSPORT_PASSAGEWAY
, categories::TRANSPORT_TRANSITION_BOARDING
, categories::TRANSPORT_PASSAGEWAY_BOARDING
, categories::TRANSPORT_RAILWAY
, categories::TRANSPORT_RAILWAY_STATION
, categories::TRANSPORT_RAILWAY_PLATFORM
, categories::TRANSPORT_RAILWAY_EL
, categories::TRANSPORT_RAILWAY_JC
, categories::TRANSPORT_RAILWAY_NM
, categories::TRANSPORT_TRAM_ROUTE
, categories::TRANSPORT_STOP
, categories::TRANSPORT_TERMINAL
, categories::TRANSPORT_TRAM_EL
, categories::TRANSPORT_TRAM_JC
, categories::TRANSPORT_NM
, categories::TRANSPORT_AIRPORT
, categories::TRANSPORT_AIRPORT_TERMINAL
, categories::TRANSPORT_HELICOPTER
, categories::TRANSPORT_AIRPORT_NM
, categories::TRANSPORT_WATERWAY_ROUTE
, categories::TRANSPORT_WATERWAY_STOP
, categories::TRANSPORT_WATERWAY_EL
, categories::TRANSPORT_WATERWAY_JC
, categories::TRANSPORT_WATERWAY_NM
, categories::VEGETATION
, categories::VEGETATION_CNT
, categories::VEGETATION_FC
, categories::VEGETATION_EL
, categories::VEGETATION_JC
, categories::VEGETATION_NM
, categories::URBAN
, categories::URBAN_FC
, categories::URBAN_EL
, categories::URBAN_JC
, categories::URBAN_NM
, categories::URBAN_AREAL
, categories::URBAN_ROADNET
, categories::URBAN_ROADNET_FC
, categories::URBAN_ROADNET_EL
, categories::URBAN_ROADNET_JC
, categories::URBAN_ROADNET_AREAL
, categories::URBAN_ROADNET_PARKING_LOT
, categories::URBAN_ROADNET_PARKING_LOT_LINEAR
, categories::URBAN_ROADNET_PARKING_CONTROLLED_ZONE
, categories::URBAN_ROADNET_NM
, categories::RELIEF
, categories::RELIEF_POINT
, categories::RELIEF_FC
, categories::RELIEF_EL
, categories::RELIEF_JC
, categories::RELIEF_NM
, categories::POI_MEDICINE
, categories::POI_EDU
, categories::POI_FINANCE
, categories::POI_SHOPPING
, categories::POI_GOVERMENT
, categories::POI_RELIGION
, categories::POI_FOOD
, categories::POI_AUTO
, categories::POI_SPORT
, categories::POI_LEISURE
, categories::POI_URBAN
, categories::POI_SERVICE
, categories::POI_OTHER
, categories::POI_NM
, categories::INDOOR_PLAN
, categories::INDOOR_LEVEL
, categories::INDOOR_AREA
, categories::INDOOR_NM
, categories::INDOOR_POI_AUTO
, categories::INDOOR_POI_FOOD
, categories::INDOOR_POI_SHOPPING
, categories::INDOOR_POI_RELIGION
, categories::INDOOR_POI_SERVICE
, categories::INDOOR_POI_FINANCE
, categories::INDOOR_POI_MEDICINE
, categories::INDOOR_POI_EDU
, categories::INDOOR_POI_LEISURE
, categories::INDOOR_POI_SPORT
, categories::INDOOR_POI_GOVERMENT
, categories::INDOOR_POI_NM
, categories::POI_ENTRANCE
, categories::AD_NEUTRAL
, categories::AD_NEUTRAL_FC
, categories::AD_NEUTRAL_EL
, categories::AD_NEUTRAL_JC
, categories::REGION
, categories::VEHICLE_RESTRICTION
, categories::MRC_PEDESTRIAN_REGION
, categories::INDOOR_RADIOMAP_CAPTURER_PATH
    )
{ (void)context; }

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
