#include "module.h"
#include "../utils/polygon_checks.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::BLD;

namespace {

const size_t VISIT_BATCH_SIZE = 10000;

} // namespace

VALIDATOR_SIMPLE_CHECK( bld_geometry, BLD )
{
    context->objects<BLD>().batchVisit([&](const Building* building) {
        utils::runPolygonGeometryCheck(building, context);
    }, VISIT_BATCH_SIZE);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
