#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/misc.h"

using maps::wiki::validator::categories::BLD;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

const unsigned long MAX_HEIGHT = 800; // meters

} // namespace

VALIDATOR_SIMPLE_CHECK( bld_height, BLD )
{
    context->objects<BLD>().visit(
            [&](const Building* building)
    {
        if (!building->height().empty()) {
            auto height = utils::parseDecimalUlong(building->height());
            if (!height) {
                context->fatal(
                    "invalid-height",
                    building->geom(),
                    { building->id() });
            } else if (*height > MAX_HEIGHT) {
                context->error(
                    "too-high-object",
                    building->geom(),
                    { building->id() });
            }
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
