#pragma once
#include "module.h"
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/misc.h"

#include <utility>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

inline
bool canPassRoadElementFrom(
    const RoadElement* roadElement,
    TId fromJunctionId,
    common::AccessId condAccessId = common::AccessId::None)
{
    if (fromJunctionId != roadElement->startJunction() &&
        fromJunctionId != roadElement->endJunction())
    {
        return false;
    }
    if (condAccessId == common::AccessId::Pedestrian) {
        return true;
    }

    using Direction = RoadElement::Direction;
    const auto direction = roadElement->direction();

    if (direction == Direction::Both) {
        return true;
    }

    bool straightDirectionAllowed =
        fromJunctionId == roadElement->startJunction()
        ? direction == Direction::Forward
        : direction == Direction::Backward;

    if (roadElement->backBus() && condAccessId == common::AccessId::Bus) {
        return
            common::isSet(common::AccessId::Bus, roadElement->accessId())
            || !straightDirectionAllowed;
    }
    if (roadElement->backBicycle() && condAccessId == common::AccessId::Bicycle) {
        return
            common::isSet(common::AccessId::Bus, roadElement->accessId())
            || !straightDirectionAllowed;
    }
    if (roadElement->backTaxi() && condAccessId == common::AccessId::Taxi) {
        return
            common::isSet(common::AccessId::Bus, roadElement->accessId())
            || !straightDirectionAllowed;
    }
    return straightDirectionAllowed;
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
