#include "duplicates_check_common.h"
#include "topo_check_common.h"

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND_ANNOTATION;

namespace {
const size_t VISIT_BATCH_SIZE = 1000;
} // namespace

VALIDATOR_CHECK_PART( cond_annotation, cond_annotation_duplicates, COND_ANNOTATION, RD_JC, RD_EL )
{
    ConditionAccumulator<COND_ANNOTATION>(context).checkDuplicates("duplicate-cond-annotation");
}

VALIDATOR_CHECK_PART( cond_annotation, cond_annotation_topo, COND_ANNOTATION, RD_EL, RD_JC )
{
    context->objects<COND_ANNOTATION>().batchVisit(
        [&](const COND_ANNOTATION::TObject* condAnnotation) {
            conditionTopoCheck<COND_ANNOTATION>(context, condAnnotation, "cond_annotation");
        },
        VISIT_BATCH_SIZE);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
