#include "common.h"
#include <yandex/maps/wiki/validator/check.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND_CAM;

VALIDATOR_SIMPLE_CHECK( cond_cam_logic, COND_CAM, RD_JC, RD_EL )
{
    const auto roadElements = context->objects<RD_EL>();
    const auto junctions = context->objects<RD_JC>();
    context->objects<COND_CAM>().visit(
            [&](const Condition* condition) {
        if (!junctions.loaded(condition->viaJunction())) {
            // Condition out of AOI
            return;
        }

        if (roadElements.loaded(condition->fromRoadElement())) {
            auto fromRoadElement =
                    roadElements.byId(condition->fromRoadElement());
            if (!canPassRoadElementFrom(
                    fromRoadElement,
                    utils::oppositeJunctionId(fromRoadElement,
                                       condition->viaJunction()))) {
                context->error("unpassable-from-element",
                               utils::geomForReport(fromRoadElement),
                               { condition->id(), fromRoadElement->id() });
            }
            if (!fromRoadElement->speedLimit()) {
                context->error("no-speed-limit-on-from-element",
                               utils::geomForReport(fromRoadElement),
                               { condition->id(), fromRoadElement->id() });
            }
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
