#include "module.h"
#include "../utils/names.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <algorithm>
#include <tuple>
#include <utility>
#include <vector>

namespace maps::wiki::validator::checks {

using categories::COND_DS_EL;

namespace {
    const std::string TYPE_ICON = "icon";
} // namespace

VALIDATOR_SIMPLE_CHECK( cond_ds_el_validity, COND_DS_EL )
{
    context->objects<COND_DS_EL>().visit(
        [&](const CondDirectionSignElement* condDsEl) {
            TId parentId = condDsEl->parent();
            if (condDsEl->type() == TYPE_ICON) {
                if (!condDsEl->name().empty()) {
                    context->fatal("cond-ds-el-icon-name", boost::none, {parentId});
                }
            } else {
                if (condDsEl->name().empty()) {
                    context->fatal("cond-ds-el-empty-name", boost::none, {parentId});
                }
            }
            if (!condDsEl->name().empty() && !utils::isValidLang(condDsEl->lang())) {
                context->fatal("cond-ds-el-lang-invalid", boost::none, {parentId});
            }
        });
}

} // namespace maps::wiki::validator::checks
