#include "logic_check_common.h"

#include "../vehicle_restrictions/vehicle_restrictions_common.h"

namespace maps::wiki::validator::checks {

using categories::COND;
using categories::RD_JC;

VALIDATOR_SIMPLE_CHECK( cond_vehicle_restrictions, COND, RD_JC)
{
    const auto junctions = context->objects<RD_JC>();
    context->objects<COND>().visit([&](const Condition* condition) {
        if (!junctions.loaded(condition->viaJunction())) {
            // Condition out of AOI
            return;
        }
        const auto rdJc = junctions.byId(condition->viaJunction());
        const auto& vr = condition->vehicleRestrictionParameters();
        if (!vr) {
            if (common::AccessId::Truck == condition->accessId()) {
                context->critical(
                    "cond-truck-without-vehicle-restriction",
                    rdJc->geom(),
                    {condition->id()});
            }
        } else {
            checkVehicleRestriction(
                vr,
                "cond-",
                rdJc->geom(),
                {condition->id()},
                *context);
        }
    });
}

} // namespace maps::wiki::validator::checks
