#include "duplicates_check_common.h"

namespace maps::wiki::validator::checks {

using categories::RD_JC;
using categories::COND;

template<>
bool equal<Condition>(const Condition& left, const Condition& right)
{
    return left.fromRoadElement() == right.fromRoadElement() &&
           left.viaJunction() == right.viaJunction() &&
           left.toRoadElements() == right.toRoadElements() &&
           ((left.vehicleRestrictionParameters() == nullptr) ==
            (right.vehicleRestrictionParameters() == nullptr));
}

VALIDATOR_SIMPLE_CHECK( conditions_duplicates, COND, RD_JC )
{
    ConditionAccumulator<COND>(context).checkDuplicates("duplicate-condition");
}

} // namespace maps::wiki::validator::checks
