#include "logic_check_common.h"

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::COND;

namespace {

const size_t MAX_TO_ELEMENTS_BARRIER = 1;
const size_t MAX_TO_ELEMENTS_DEFAULT = 2;

} // namespace

VALIDATOR_CHECK_PART( conditions_logic, passability, COND, RD_JC, RD_EL )
{
    context->objects<COND>().visit([&](const Condition* condition) {
        if (condition->type() == common::ConditionType::Barrier) {
            conditionPassabilityCheck<COND>(context, condition,
                MAX_TO_ELEMENTS_BARRIER, Severity::Critical);
        } else {
            conditionPassabilityCheck<COND>(context, condition,
                MAX_TO_ELEMENTS_DEFAULT, Severity::Warning);
        }
    });
}

VALIDATOR_CHECK_PART( conditions_logic, access_id, COND, RD_JC, RD_EL )
{
    std::vector<TId> idsToReport;

    context->objects<COND>().visit([&](const Condition* condition) {
        conditionAccessIdCheck<COND>(context, condition, "condition", idsToReport);
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
