#include "module.h"
#include <yandex/maps/wiki/common/date_time.h>
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <algorithm>
#include <tuple>
#include <utility>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using categories::COND_DT;

VALIDATOR_SIMPLE_CHECK( conditions_schedules, COND_DT )
{
    context->objects<COND_DT>().visit(
            [&](const Schedule* schedule) {
        TId parentId = schedule->affectedObject().id;
        if (!schedule->timeStart().empty() || !schedule->timeEnd().empty()) {
            if (!common::Time(schedule->timeStart()).isValid()) {
                context->critical("bad-time-start", boost::none, {parentId});
            }
            if (!common::Time(schedule->timeEnd()).isValid()) {
                context->critical("bad-time-end", boost::none, {parentId});
            }
        }

        if (!schedule->dateStart().empty() || !schedule->dateEnd().empty()) {
            if (!common::Date(schedule->dateStart()).isValid()) {
                context->critical("bad-date-start", boost::none, {parentId});
            }
            if (!common::Date(schedule->dateEnd()).isValid()) {
                context->critical("bad-date-end", boost::none, {parentId});
            }
        }
    });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
