#pragma once

#include "../utils/road_utils.h"

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/common/rd/access_id.h>
#include <yandex/maps/wiki/graph/strongly_connected_components.h>

#include <set>
#include <vector>

namespace maps::wiki::validator::checks {

class GraphComponent
{
public:
    enum class Type
    {
        Primary,
        Secondary
    };

    static const size_t MAX_REPRESENTATIVES_COUNT = 10;

    GraphComponent() {}
    GraphComponent(
        CheckContext* context,
        const graph::NodeIds& component,
        Type type);

    geolib3::Polygon2 geom;
    std::vector<TId> representatives;

    bool onAoiBorder;
    bool isolated;
};

typedef std::vector<GraphComponent> GraphComponents;

bool
calculateBorderFlag(
    CheckContext* context,
    const std::set<TId>& component);

bool
calculateIsolatedFlag(
    CheckContext* context,
    const std::set<TId>& component,
    utils::RdElFilter graphFilter);

class StronglyConnectedComponentReport
{
public:
    StronglyConnectedComponentReport(
        CheckContext* context,
        const graph::StronglyConnectedComponents& components,
        utils::RdElFilter graphFilter);

    const GraphComponent& primary() const
    { return primary_; }

    const GraphComponents& secondaries() const
    { return secondaries_; }

private:
    void unionSecondaries(
        CheckContext* context,
        const graph::StronglyConnectedComponents& components,
        utils::RdElFilter graphFilter);

    GraphComponent primary_;
    GraphComponents secondaries_;
};

} // namespace maps::wiki::validator::checks
