#include "road_network.h"

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;

RoadNetwork::RoadNetwork(
        CheckContext* context,
        utils::RdElFilter graphFilter,
        const utils::RdElContinuationsByJcId& prohibitedContinuations,
        Directed directed,
        utils::RdElFilter backLaneFilter,
        utils::RdElDirectionFilter directionFilter)
    : context_(context)
    , graphFilter_(graphFilter)
    , prohibitedContinuations_(prohibitedContinuations)
    , directed_(directed)
    , backLaneFilter_(backLaneFilter)
    , directionFilter_(directionFilter)
{
}

graph::Edges
RoadNetwork::outEdges(graph::NodeID nodeId) const
{
    const auto& continuations = findRdElContinuations(
        context_,
        nodeId,
        graphFilter_,
        prohibitedContinuations_,
        directed_ == Directed::Yes
            ? utils::IncidenceDirection::Out
            : utils::IncidenceDirection::Both,
        backLaneFilter_,
        directionFilter_);

    graph::Edges result;
    result.reserve(continuations.size());
    for (auto rdEl : continuations) {
        result.emplace_back(nodeId, rdEl->id());
    }
    return result;
}

} // namespace maps::wiki::validator::checks
