#pragma once

#include "../utils/road_utils.h"

#include <yandex/maps/wiki/graph/graph.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

class RoadNetwork
{
public:
    enum class Directed
    {
        Yes,
        No
    };

    RoadNetwork(
        CheckContext* context,
        utils::RdElFilter graphFilter,
        const utils::RdElContinuationsByJcId& prohibitedContinuations,
        Directed directed = RoadNetwork::Directed::Yes,
        utils::RdElFilter backLaneFilter = [](const RoadElement*) { return false; },
        // Function should check if route can leave junction by elements direction
        utils::RdElDirectionFilter directionFilter = [](const RoadElement*, TId) { return true; });

    bool filterRdEl(const RoadElement* rdEl) const
    { return graphFilter_(rdEl); }

    graph::Edges outEdges(graph::NodeID nodeId) const;

private:
    CheckContext* context_;
    utils::RdElFilter graphFilter_;
    const utils::RdElContinuationsByJcId& prohibitedContinuations_;
    Directed directed_;
    utils::RdElFilter backLaneFilter_;
    utils::RdElDirectionFilter directionFilter_;
};

} // namespace maps::wiki::validator::checks
