#include "strong_connectivity_checks_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;

VALIDATOR_SIMPLE_CHECK( strong_connectivity_bicycle, RD_EL, RD_JC )
{
    utils::RdElContinuationsByJcId prohibitedContinuations;

    RoadNetwork roadNetwork(
        context,
        [](const RoadElement* rdEl) {
            return
                rdEl->backBicycle() ||
                common::AccessId::None !=
                    (rdEl->accessId() &
                        (common::AccessId::Pedestrian |
                         common::AccessId::Bicycle));
        },
        prohibitedContinuations,
        RoadNetwork::Directed::Yes,
        [](const RoadElement* rdEl) {
            return rdEl->backBicycle();
        },
        [](const RoadElement* rdEl, TId jcId) {
            if (common::AccessId::None !=
                (rdEl->accessId() & common::AccessId::Pedestrian))
            {
                return true;
            }
            const auto bicycleAccess =
                (common::AccessId::None !=
                    (rdEl->accessId() & common::AccessId::Bicycle));
            if (bicycleAccess &&
                (rdEl->direction() == RoadElement::Direction::Both ||
                rdEl->backBicycle()))
            {
                return true;
            }
            if (rdEl->backBicycle()) {
                return
                    (rdEl->direction() == RoadElement::Direction::Backward
                        && rdEl->startJunction() == jcId) ||
                    (rdEl->direction() == RoadElement::Direction::Forward
                        && rdEl->endJunction() == jcId);
            } else {
                return
                    (rdEl->direction() == RoadElement::Direction::Forward
                        && rdEl->startJunction() == jcId) ||
                    (rdEl->direction() == RoadElement::Direction::Backward
                        && rdEl->endJunction() == jcId);
            }
        });

    checkStrongConnectivity(context, roadNetwork);
}

} // namespace maps::wiki::validator::checks
