#include "strong_connectivity_checks_common.h"
#include "component_report.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND;

void
checkStrongConnectivityByFc(
    CheckContext* context,
    int curFc,
    Severity errorSeverity)
{
    auto prohibitedContinuations = utils::findProhibitedContinuations(
        context, common::AccessId::Car);

    const utils::RoadAccessIdFilter carFilter(common::AccessId::Car);

    auto roadFilterFc = [&](const RoadElement* rdEl) {
        return rdEl->fc() <= curFc && carFilter(rdEl);
    };

    RoadNetwork roadNetwork(
        context,
        roadFilterFc,
        prohibitedContinuations,
        RoadNetwork::Directed::Yes);

    auto descrSuffix = "-fc" + std::to_string(curFc);

    checkStrongConnectivity(
        context,
        roadNetwork,
        errorSeverity,
        descrSuffix);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_1, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 1, Severity::Critical);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_2, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 2, Severity::Critical);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_3, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 3, Severity::Critical);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_4, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 4, Severity::Critical);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_5, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 5, Severity::Error);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_6, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 6, Severity::Error);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_7, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 7, Severity::Error);
}

VALIDATOR_CHECK_PART( strong_connectivity_by_fc, fc_9, RD_EL, RD_JC, COND )
{
    checkStrongConnectivityByFc(context, 9, Severity::Error);
}

} // namespace maps::wiki::validator::checks
