#include "strong_connectivity_checks_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND;

namespace {
const auto MOTO_ACCESS_FILTER =
    common::AccessId::Car |
    common::AccessId::Moto;
} // namespace

VALIDATOR_SIMPLE_CHECK( strong_connectivity_moto, RD_EL, RD_JC, COND )
{
    auto prohibitedContinuations = utils::findProhibitedContinuations(
        context, MOTO_ACCESS_FILTER);

    auto motoRdElFilter = [](const RoadElement* rdEl) -> bool {
        return
            (rdEl->accessId() & common::AccessId::Moto) != common::AccessId::None ||
            (!rdEl->noMotoAccess() &&
                ((rdEl->accessId() & MOTO_ACCESS_FILTER) != common::AccessId::None)
            );
    };

    RoadNetwork roadNetwork(
        context,
        motoRdElFilter,
        prohibitedContinuations,
        RoadNetwork::Directed::Yes,
        [](const RoadElement*) { return false; });

    checkStrongConnectivity(context, roadNetwork);
}

} // namespace maps::wiki::validator::checks
