#include "strong_connectivity_checks_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;

VALIDATOR_SIMPLE_CHECK( strong_connectivity_pedestrian, RD_EL, RD_JC )
{
    utils::RdElContinuationsByJcId prohibitedContinuations;

    RoadNetwork roadNetwork(
        context,
        utils::RoadAccessIdFilter(common::AccessId::Pedestrian),
        prohibitedContinuations,
        RoadNetwork::Directed::No);

    checkStrongConnectivity(context, roadNetwork);
}

} // namespace maps::wiki::validator::checks
