#include "strong_connectivity_checks_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND;

namespace {
const auto SCOOTER_ACCESS_FILTER =
    common::AccessId::Pedestrian |
    common::AccessId::Bicycle |
    common::AccessId::Scooter;
} // namespace

VALIDATOR_SIMPLE_CHECK( strong_connectivity_scooter, RD_EL, RD_JC, COND )
{
    auto prohibitedContinuations = utils::findProhibitedContinuations(
        context, SCOOTER_ACCESS_FILTER);

    auto scooterRdElFilter = [](const RoadElement* rdEl) -> bool {
        return
            (rdEl->accessId() & common::AccessId::Scooter) != common::AccessId::None ||
            (!rdEl->noScooterAccess() &&
                ((rdEl->accessId() & SCOOTER_ACCESS_FILTER) != common::AccessId::None)
            );
    };

    RoadNetwork roadNetwork(
        context,
        scooterRdElFilter,
        prohibitedContinuations,
        RoadNetwork::Directed::Yes,
        [](const RoadElement*) { return false; });

    checkStrongConnectivity(context, roadNetwork);
}

} // namespace maps::wiki::validator::checks
