#include "strong_connectivity_checks_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::RD_EL;
using categories::RD_JC;
using categories::COND;

VALIDATOR_SIMPLE_CHECK( strong_connectivity_taxi, RD_EL, RD_JC, COND )
{
    auto prohibitedContinuations = utils::findProhibitedContinuations(
        context, common::AccessId::Taxi);

    RoadNetwork roadNetwork(
        context,
        utils::RoadAccessIdFilter(common::AccessId::Taxi),
        prohibitedContinuations,
        RoadNetwork::Directed::Yes,
        utils::BackLaneTaxiFilter());

    checkStrongConnectivity(context, roadNetwork);
}

} // namespace maps::wiki::validator::checks
