#!/bin/sh
CATEGORIES=../../../libs/validator/include/yandex/maps/wiki/validator/categories.h
(
cat <<EOF
#ifndef YANDEX_MAPS_BUILD
#define MODULE_NAME "base-only-check"
#endif

#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( base_only, hydro
EOF

awk '$1 == "struct" { if ($2 ~ /^HYDRO/) print ", categories::"$2; }' \
    $CATEGORIES

cat <<EOF
    )
{ (void)context; }

VALIDATOR_CHECK_PART( base_only, other
EOF

awk '$1 == "struct" { if ($2 !~ /^HYDRO/) print ", categories::"$2; }' \
    $CATEGORIES

cat <<EOF
    )
{ (void)context; }


VALIDATOR_CHECK_PART( base_with_cardinality, hydro
EOF

awk '$1 == "struct" { if ($2 ~ /^HYDRO/) print ", categories::"$2; }' \
    $CATEGORIES

cat <<EOF
    )
{ (void)context; }

VALIDATOR_CHECK_PART( base_with_cardinality, other
EOF

awk '$1 == "struct" { if ($2 !~ /^HYDRO/) print ", categories::"$2; }' \
    $CATEGORIES

cat <<EOF
    )
{ (void)context; }

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
EOF
) >base_only_check.cpp
