#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/face_builder.h"
#include "../utils/face_checks.h"

using maps::wiki::validator::categories::HYDRO;
using maps::wiki::validator::categories::HYDRO_FC;
using maps::wiki::validator::categories::HYDRO_FC_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

namespace {

//To descrease probability of getting several heavy objects in one batch
constexpr size_t BATCH_SIZE = 100;

} // namespace

VALIDATOR_SIMPLE_CHECK( hydro_geometry, HYDRO, HYDRO_FC, HYDRO_FC_EL )
{
    utils::runFaceIntersectionsNestingCheck<HYDRO>(context, BATCH_SIZE);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
