#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::HYDRO;
using maps::wiki::validator::categories::HYDRO_LN;
using maps::wiki::validator::categories::HYDRO_POINT;
using maps::wiki::validator::categories::HYDRO_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART ( hydro_naming, hydro, HYDRO, HYDRO_NM )
{
    context->objects<HYDRO>().visit(
        [&](const ContourFeature* hydro) {
            utils::runBasicNamesCheck<HYDRO_NM>(hydro, context);
        }
    );
}

VALIDATOR_CHECK_PART ( hydro_naming, hydro_ln, HYDRO_LN, HYDRO_NM )
{
    context->objects<HYDRO_LN>().visit(
        [&](const LinearFeature* hydro) {
            utils::runBasicNamesCheck<HYDRO_NM>(hydro, context);
        }
    );
}

VALIDATOR_CHECK_PART( hydro_naming, point, HYDRO_POINT, HYDRO_NM )
{
    context->objects<HYDRO_POINT>().visit(
        [&](const PointFeature* hydro) {
            utils::runBasicNamesCheck<HYDRO_NM>(hydro, context);
        }
    );
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
