#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::HYDRO;
using maps::wiki::validator::categories::HYDRO_FC;
using maps::wiki::validator::categories::HYDRO_FC_EL;

using maps::wiki::validator::categories::HYDRO_LN;
using maps::wiki::validator::categories::HYDRO_LN_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        hydro_relations, face_elements_relations, HYDRO_FC_EL, HYDRO_FC )
{
    utils::runElementsRelationsCheck<HYDRO_FC_EL, HYDRO_FC>(
            context, Severity::Fatal);
}

VALIDATOR_CHECK_PART(
        hydro_relations, faces_relations, HYDRO_FC, HYDRO_FC_EL, HYDRO )
{
    utils::runFacesRelationsCheck<HYDRO_FC, HYDRO>(context);
}

VALIDATOR_CHECK_PART(
        hydro_relations, contour_objects_relations,
        HYDRO, HYDRO_FC )
{
    utils::runFeatureRelationsCheck<HYDRO>(context);
}

VALIDATOR_CHECK_PART(
        hydro_relations, linear_objects_relations,
        HYDRO_LN, HYDRO_LN_EL )
{
    utils::runFeatureRelationsCheck<HYDRO_LN>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
