#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/message.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::HYDRO_FC;
using maps::wiki::validator::categories::HYDRO_FC_EL;
using maps::wiki::validator::categories::HYDRO_FC_JC;
using maps::wiki::validator::categories::HYDRO_LN_EL;
using maps::wiki::validator::categories::HYDRO_LN_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( hydro_topology_face, segments_length, HYDRO_FC_EL )
{
    utils::runSegmentsLengthCheck<HYDRO_FC_EL>(context);
}

VALIDATOR_CHECK_PART( hydro_topology_face, intersections,
        HYDRO_FC, HYDRO_FC_EL )
{
    utils::runFaceElementsIntersectionsCheck<HYDRO_FC_EL, HYDRO_FC>(context);
}

VALIDATOR_CHECK_PART( hydro_topology_face, jc_el_coverage,
        HYDRO_FC_EL, HYDRO_FC_JC )
{
    utils::runJcElCoverageCheck<HYDRO_FC_EL, HYDRO_FC_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( hydro_topology_face, open_bounds, HYDRO_FC_JC )
{
    utils::runOpenBoundsCheck<HYDRO_FC_JC>(context);
}

VALIDATOR_CHECK_PART( hydro_topology_linear, segments_length, HYDRO_LN_EL )
{
    utils::runSegmentsLengthCheck<HYDRO_LN_EL>(context);
}

VALIDATOR_CHECK_PART( hydro_topology_linear, intersections, HYDRO_LN_EL )
{
    utils::runLinearElementsIntersectionsCheck<HYDRO_LN_EL>(
            context, Severity::Warning);
}

VALIDATOR_CHECK_PART( hydro_topology_linear, jc_el_coverage,
        HYDRO_LN_EL, HYDRO_LN_JC )
{
    utils::runJcElCoverageCheck<HYDRO_LN_EL, HYDRO_LN_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
