#include "indoor_common.h"

namespace maps::wiki::validator::checks {

using categories::INDOOR_PLAN;
using categories::INDOOR_LEVEL;

IndoorPlanToLevelsMap getIndoorLevelsByPlan(CheckContext* context)
{
    IndoorPlanToLevelsMap result;
    context->objects<INDOOR_LEVEL>().visit(
        [&](const IndoorLevel* indoorLevel)
    {
        auto indoorPlanId = indoorLevel->parent();
        if (context->objects<INDOOR_PLAN>().loaded(indoorPlanId)) {
            auto indoorPlan = context->objects<INDOOR_PLAN>().byId(indoorPlanId);
            result[indoorPlan].push_back(indoorLevel);
        }
    });
    return result;
}

} // namespace maps::wiki::validator::checks
