#include "module.h"
#include "indoor_common.h"
#include "../utils/names.h"

namespace maps::wiki::validator::checks {

using categories::INDOOR_PLAN;
using categories::INDOOR_LEVEL;
using categories::INDOOR_NM;

VALIDATOR_SIMPLE_CHECK( indoor_name_lang, INDOOR_PLAN, INDOOR_LEVEL, INDOOR_NM )
{
    auto indoorLevelsByPlan = getIndoorLevelsByPlan(context);

    for (const auto& [indoorPlan, indoorLevels] : indoorLevelsByPlan) {
        auto langs = utils::langsFromNames<INDOOR_NM>(indoorPlan->names(), context);

        std::vector<TId> badLevelIds;
        for (const auto* indoorLevel : indoorLevels) {
            if (langs != utils::langsFromNames<INDOOR_NM>(
                indoorLevel->names(), context)) {
                    badLevelIds.push_back(indoorLevel->id());
            }
        }

        if (!badLevelIds.empty()) {
            context->fatal(
                "indoor-plan-levels-different-langs",
                indoorPlan->geom(),
                badLevelIds);
        }
    }
}

} // namespace maps::wiki::validator::checks
