#ifndef YANDEX_MAPS_BUILD
#define MODULE_NAME "local-names-checks"
#endif

#include "nm_categories.h"
#include "local_names_check.h"
#include "../utils/name_data.h"

#include <yandex/maps/wiki/validator/check.h>
#include <unordered_map>
#include <algorithm>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using namespace categories;

namespace {

template<class NameCategory>
struct LocalNamesChecker
{
    static void performCheck(CheckContext* context)
    {
        std::unordered_map<TId, bool> objectHasLocalName;
        context->objects<NameCategory>().visit([&](const Name* name) {
            auto objectId = name->parentId();
            if (!objectId) {
                return;
            }
            if (name->isLocal()) {
                objectHasLocalName[objectId] = true;
            } else {
                objectHasLocalName.insert({objectId, false});
            }
        });

        for (const auto& hasLocalName : objectHasLocalName) {
            if (!hasLocalName.second) {
                context->error(
                        "local-name-missing", boost::none, { hasLocalName.first });
            }
        }
    }
    static std::string checkName()
    {
        return "local_names_" + NameCategory::id();
    }
};

} // namespace

template <>
class LocalNamesCheckRegistrar<LocalNamesChecker>
{};

LocalNamesCheckRegistrar<LocalNamesChecker, NM_CATEGORIES> LOCAL_NAMES_REGISTRAR;

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
