#pragma once
#include <yandex/maps/wiki/validator/check.h>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

template <template<typename> class Checker, typename NameCategory>
class LocalNamesCheck : public maps::wiki::validator::ICheckPart
{
public:
    void run(maps::wiki::validator::CheckContext* context)
    {
        Checker<NameCategory>::performCheck(context);
    }

    static std::vector<maps::wiki::validator::TCategoryId>
    categoryDependencies()
    {
        return {NameCategory::id()};
    }
};

template <template<typename> class Checker, typename... Categories>
class LocalNamesCheckRegistrar;

template <template<typename> class Checker, typename NameCategory, typename... Categories>
class LocalNamesCheckRegistrar<Checker, NameCategory, Categories...>
{
public:
    typedef LocalNamesCheckRegistrar<Checker, Categories ...> NextRegistrar;
    typedef LocalNamesCheck<Checker, NameCategory> CategoryLocalNamesCheck;
    LocalNamesCheckRegistrar()
    {
        maps::wiki::validator::CheckPartRegistrar<CategoryLocalNamesCheck>
            localNames_registrar(
#ifdef YANDEX_MAPS_BUILD
                &maps::wiki::validator::moduleCheckRegistry(),
#else
                MODULE_NAME,
#endif
                Checker<NameCategory>::checkName(),
                {});
    }
    NextRegistrar next;
};

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
