#ifndef YANDEX_MAPS_BUILD
#define MODULE_NAME "local-ukr-names-checks"
#endif

#include "nm_categories.h"
#include "local_names_check.h"
#include "../utils/name_data.h"

#include <yandex/maps/wiki/validator/check.h>
#include <unordered_map>
#include <algorithm>

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

using namespace categories;

namespace {
template<class NameCategory>
struct LocalUkrNamesChecker
{

    static void performCheck(CheckContext* context)
    {
        std::unordered_map<TId, bool> objectHasLocalName;
        context->objects<NameCategory>().visit([&](const Name* name) {
            auto objectId = name->parentId();
            if (!objectId) {
                return;
            }
            if (name->lang() == LANG_UK && name->isLocal()
                  && name->type() == NameRelation::Type::Official) {
                objectHasLocalName[objectId] = true;
            } else {
                objectHasLocalName.insert({objectId, false});
            }
        });

        for (const auto& hasLocalName : objectHasLocalName) {
            if (!hasLocalName.second) {
                context->error(
                        "ukr-local-name-missing", boost::none, { hasLocalName.first });
            }
        }
        return;
    }
    static std::string checkName()
    {
        return "ukr_names_" + NameCategory::id();
    }
};
} // namespace

template <>
class LocalNamesCheckRegistrar<LocalUkrNamesChecker>
{};

LocalNamesCheckRegistrar<LocalUkrNamesChecker, NM_CATEGORIES> LOCAL_UKR_NAMES_REGISTRAR;


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
