#include "module.h"
#include "poi_categories.h"

#include <yandex/maps/wiki/common/misc.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

namespace {

template<class CategoryName>
bool performCheck(CheckContext* context)
{
    context->objects<CategoryName>().visit([&](const Poi* poi)
    {
        if (common::isIn(
                poi->positionQuality(),
                {Poi::PositionQuality::Empty, Poi::PositionQuality::Auto}))
        {
            context->error(
                "poi-not-verified",
                poi->geom(),
                {poi->id()});
        }
    });
    return true;
}

template<class... Categories>
void performChecks(CheckContext* context)
{
    auto performed = {performCheck<Categories>(context)...};
    (void)performed;
}

} // namespace

VALIDATOR_SIMPLE_CHECK( poi_position_quality, POI_CATEGORIES )
{
    performChecks<POI_CATEGORIES>(context);
}

} // maps::wiki::validator::checks
